using System;
using System.Collections;
using com.plumtree.openfoundation.util;
using com.plumtree.openlog;
using com.plumtree.portalnavigation.common.constants;
using com.plumtree.portalpages.browsing.myportal;
using com.plumtree.portalpages.browsing.myportal.communities;
using com.plumtree.portalpages.common.mediator;
using com.plumtree.portalpages.common.plugnav;
using com.plumtree.portalpages.common.uiparts;
using com.plumtree.portalpages.common.uiparts.navpagetype;
using com.plumtree.portaluiinfrastructure.compoundlist;
using com.plumtree.portaluiinfrastructure.opener;
using com.plumtree.portaluiinfrastructure.statichelpers;
using com.plumtree.uiinfrastructure.activityspace;
using com.plumtree.uiinfrastructure.activityspace.utils;
using com.plumtree.uiinfrastructure.htmlconstructs;
using com.plumtree.uiinfrastructure.opener;
using com.plumtree.uiinfrastructure.statichelpers;
using com.plumtree.xpshared.htmlconstructs;
using com.plumtree.xpshared.htmlelements;
//Put explicit import for Interpreter (to avoid ambiguity of using the deprecated class)
using Interpreter=com.plumtree.uiinfrastructure.interpreter.Interpreter;
namespace com.plumtree.portalnavigation.views
{
	/// <summary>
	/// Horizontal navigation view for displaying drop-down menus using
	///  jsportalmenus, and combobox framework.
	///  
	///  This navigation view displays a three tab horizontal menu with community specific 
	///  content. The menu entries are listed in a row and one set of entries is always displayed
	///  in the row. Clicking on one of the tabs displays the entries for that tab. Menu 
	///  entries will wrap to multiple rows when necessary.
	///  
	///  This view is used by the NavTypeJSPortalMenuDropDown 
	///  navigation scheme in the below banner section. It uses javascript functions defined in navtabsections.js 
	///  (included in NavTypeJSPortalMenuDropDown.java). NavTypeJSPortalMenuDropDown also relies on 
	///  markers in this view ( NavigationCommonHelpers.CreateDropDownEndMarkers() ).
	///  
	///  Now supports browser detection internally, so this view can be used
	///  as a nested view by other navigation views.
	///  
	///  This view supports auto-browser handling so it can be used by external
	///  custom navigations.  Custom navs thatuse this view MUST also use the 
	///  JavaScriptIncludes() method on NavTypeJSPortalMenuDropDown to return 
	///  proper javascript to support this view.
	/// </summary>
	/// <author>robertz</author>
	/// <author>DavidP</author>
	/// <author>MichaelD</author>
	public class subcommalphaorder : IView
	{
		public subcommalphaorder() : base()
		{
		}
		private static OpenLogger log = OpenLogService.GetLogger(OpenLogService.GetComponent(PTDebugHelpers.COMPONENT_PORTAL_COMMON),
			"com.plumtree.portalnavigation.views.subcommalphaorder");
    
		/// <summary>
		/// MVC ID
		/// </summary>
		public const String STR_MVC_CLASS_NAME = "NavigationCommSectionDropDown";
		// IDs for each of the tabs
		protected const String m_strInCommID = "InComm";
		protected const String m_strRelComms = "RelComms";
		protected const String m_strSubComms = "SubComms";
		// Name of the javascript variable with the HTML for the tabs row
		public const String VARNAME_TABSHTML = "tabsString";
		protected int m_nNumberCols = 0;
		private AActivitySpace m_asOwner;
		private IPluggableNavModelRO m_model;
		// we use these views for dynamic routing of browser handling
		private NavigationCommSectionComboBoxView m_communityComboBoxView = null;
    
		/// <seealso cref="com.plumtree.uiinfrastructure.activityspace.IManagedObject#Create()"></seealso>
		public virtual Object Create()
		{
			return new subcommalphaorder();
		}
    
		/// <seealso cref="com.plumtree.uiinfrastructure.activityspace.IView#Display()"></seealso>
		public virtual HTMLElement Display()
		{
			HTMLElementCollection result = new HTMLElementCollection();
			// Detect the browser type and map to the right menu view
			BrowserType browser = (BrowserType) m_asOwner.GetSubSession().GetAttribute(Interpreter.BROWSERTYPE);
			// Combobox Menus: Netscape 4 All Platforms, Macintosh Safari
			// Safari note: Must wait until Konqueror supports W3C spec 
			// for Javascript, slated for Safari 2.0
			// Also get combobox for anything we don't recognize
			// Note javascript handling is browser-specific in NavType also.
			if (!browser.IsJSPortalMenuCompliant())
			{
				HTMLElement resultElt = m_communityComboBoxView.Display();
				if (resultElt != null)
				{
					result.AddInnerHTMLElement(resultElt);
				}
      } else
      // Tabs: Netscape > 4 All Platforms, and IE all platforms  
			{
				try
				{
					// Only show this view on community pages
					if (NavPageType.COMMUNITY == m_model.GetCurNavPageType())
					{
						CommunityNavPage commP = (CommunityNavPage) m_model.GetPageSpecificMethods();
						m_nNumberCols = 0;
						// Table with the tabs
						HTMLTable table = new HTMLTable();
						/*
						 The HTML of the table is not displayed in a regular way.
						 We get the HTML from the table as a string and put it to a javascript
						 variable. The HTML will be written to the page dynamically with javascript.
						 Set all these settings on the table element since we get the html from the
						 table as a string
						 */
             
						table.SetForceLineBreaksAfterSafeElements(false);
						table.SetImgBaseUrl(ConfigHelper.GetImageServerBaseURL(m_asOwner));
						table.SetWidth(CommonHTMLStrings.ONE_HUNDRED_PERCENT);
						table.SetBorder(CommonHTMLStrings.ZERO);
						table.SetCellPadding(CommonHTMLStrings.ZERO);
						table.SetCellSpacing(CommonHTMLStrings.ZERO);
						HTMLScript script = new HTMLScript(HTMLScript.TYPE_JAVASCRIPT);
						HTMLTableRow tRow = null;
						HTMLTableCell tCell = null;
						// TABS ROW
						tRow = new HTMLTableRow();
						tRow.SetStyleClass(PTStyleClass.NAV_TABOFF_BG);
						NavigationCommonHelpers.CreateHorizontalSpacerCell(tRow);
						// Add the "In this community" tab
						AddGroupsTab(tRow, m_asOwner.GetString(324, ResourceConstants.PORTALCOMMONMSGS),
							m_asOwner.GetString(641, ResourceConstants.PORTALCOMMONMSGS),
							m_strInCommID);
						// Add the "Subcommunities" tab if any
						// mj: don't display this section if there are no subcommunities
						ICPListEntryIterator cpSubComms = commP.GetCurSubCommunities();
						if (cpSubComms.GetTotalCount() > 0)
						{
							AddGroupsTab(tRow, m_asOwner.GetString(325, ResourceConstants.PORTALCOMMONMSGS),
								m_asOwner.GetString(642, ResourceConstants.PORTALCOMMONMSGS),
								m_strSubComms);
						}
						ICPListEntryIterator cpParComms = commP.GetParentComm();





						ICPListEntryIterator cpRelComms = commP.GetCurRelCommunities();




						// Add the "Related tab" if any
						// Don't display this section if there are no related communities.
						if (cpRelComms.GetTotalCount() > 0)
						{
							result.AddInnerHTMLElement(PopulateRelatedCommsRow(m_strRelComms,
								cpRelComms));
							AddGroupsTab(tRow, m_asOwner.GetString(326, ResourceConstants.PORTALCOMMONMSGS),
								m_asOwner.GetString(643, ResourceConstants.PORTALCOMMONMSGS),
								m_strRelComms);
						}
						// Add the "Go to parentcommunity" tab if a parent community exists
						AddGoToParentCommTab(tRow, cpParComms);
						// mj: only display this row if we're supposed to
						if (commP.ShowCommunityNavigation())
						{
							// Spacer cell to pad the row to the end of the page
							tCell = new HTMLTableCell();
							tRow.AddInnerHTMLElement(tCell);
							tCell.SetWidth(CommonHTMLStrings.ONE_HUNDRED_PERCENT);
							tCell.SetStyleClass(PTStyleClass.BAN_HEADER_BG);
							tCell.AddInnerHTMLString(CommonHTMLStrings.SPACE);
							table.AddInnerHTMLElement(tRow);
						}
						/*
						 Create the html for the links in the row below the tabs
						 The HTML for each set of links (community pages, subcommunities, related communities),
						 which consists of a table with one row, is put into a javascript variable. The
						 corresponding html is dynamically inserted to the page based on what tab is selected
						 by javascript.
						 */
             
						// The html container where the tabs table html is inserted
						// Div for IE and Layer for Netscape					
						HTMLDiv tabsdiv = new HTMLDiv();
						tabsdiv.SetID("tabsdivcontainer");
						HTMLLayer tabslayer = new HTMLLayer();
						tabslayer.SetID("tabslayercontainer");
						// The html container where the links table html is inserted
						// Div for IE and Layer for Netscape
						HTMLDiv rowdiv = new HTMLDiv();
						rowdiv.SetID("rowdivcontainer");
						HTMLLayer rowlayer = new HTMLLayer();
						rowlayer.SetID("rowlayercontainer");
						// First community pages
						ICPListEntryIterator cpList = commP.GetCurCommPages();
						result.AddInnerHTMLElement(PopulateLinksRow(m_strInCommID, cpList, false));
						// Subcommunities 
						if (cpSubComms.GetTotalCount() > 0)
						{
							result.AddInnerHTMLElement(PopulateLinksRow(m_strSubComms, cpSubComms, true));
						}
						// The js variable containing the HTML table for the tabs
						result.AddInnerHTMLElement(JSHelper.AddSafeJSVariable(VARNAME_TABSHTML,
							"\'" + table.GetDisplayString() + "\'"));
						// Display the "In this community" links row when page finishes loading, 
						// register the page onload even through the PPC
						script.AddInnerHTMLString("\t" + "document.PCC.RegisterForWindowEvent(\"onload\", showGroupsTabRowOnLoad);\n" + "function showGroupsTabRowOnLoad()\n" + "{\n" + "\tshowGroupsTabRow(\'" + m_strInCommID + "\', 1);\n" + "}\n");
						result.AddInnerHTMLString("<!-- Start Category Tabs -->");
						// Add the tab containers
						result.AddInnerHTMLElement(tabsdiv);
						result.AddInnerHTMLElement(tabslayer);
						// Need extra spacing in netscape 4
						//Object bIsNS4 = m_asOwner.GetSubSession().GetAttribute("ISNS4");
						//if ((null != bIsNS4) && XPConvert.ToBoolean(bIsNS4))
						if (browser.IsNetscape4())
						{
							result.AddInnerHTMLElement(new HTMLBr());
						}
						// Add the row containers
						result.AddInnerHTMLElement(rowdiv);
						result.AddInnerHTMLElement(rowlayer);
						result.AddInnerHTMLElement(script);
						// Additional spacing for Netscape 4
						if (browser.IsNetscape4())
						{
							result.AddInnerHTMLElement(new HTMLBr());
						}
						result.AddInnerHTMLString("<!-- End Category Tabs -->");
					}
					// end of if community page
					/*
					 Add the dropdown marker used by the ISC menus.
					 This element sets the bottom boundary for how big
					 the ISC dropdown menus in the default mode can go. Should be placed below
					 the banner so the menus display above the gadget content area where burn-throughs
					 can occur. The ISC dropdown menus also has an alternative mode which disregards
					 this marker.
					 */
           
					result.AddInnerHTMLElement(NavigationCommonHelpers.CreateDropDownEndMarkers());
				}
				catch (Exception e)
				{
					log.Error(e, "Could not display Community Section DropDown View: ");
					return new HTMLGenericElement("Error displaying the Category tabs: " + e.Message);
				}
			}
			return result;
		}
    
		/// <seealso cref="com.plumtree.uiinfrastructure.activityspace.IView#DisplayJavascript()"></seealso>
		public virtual HTMLScript DisplayJavascript()
		{
			return null;
		}
    
		/// <seealso cref="com.plumtree.uiinfrastructure.activityspace.IMVCObject#GetName()"></seealso>
		public virtual String GetName()
		{
			return STR_MVC_CLASS_NAME;
		}
    
		/// <seealso cref="com.plumtree.uiinfrastructure.activityspace.IView#Init(IModelRO,">AActivitySpace)</seealso>
		public virtual void Init(IModelRO model, AActivitySpace parent)
		{
			m_asOwner = parent;
			m_model = (IPluggableNavModelRO) model;
			m_communityComboBoxView = new NavigationCommSectionComboBoxView();
			m_communityComboBoxView.Init(model, parent);
		}
    
		/// <summary>
		/// NavigationCommSectionComboBoxView has a copy of this funtion too, update both.
		///  Note that the javascript link is different in the two functions.
		/// </summary>
		/// <param name="tRow">The HTMLTableRow where the generated Tab is added to</param>
		/// <param name="cpList">ICPListIterator with a parent community (can only be one) or empty list if none exists.</param>
		/// <throws>Exception</throws>
		protected virtual void AddGoToParentCommTab(HTMLTableRow tRow, ICPListEntryIterator cpList)
		{
			CListURLTemplateMediator mediator = new CListURLTemplateMediator(m_asOwner,
				cpList);
			if (!mediator.Next())
			{
				// No parent community, don't need this tab
				return;
			}
			// Cell with the image
			HTMLTableCell tCell = new HTMLTableCell();
			tCell.SetNoWrap(true);
			tCell.SetHeight("20");
			tRow.AddInnerHTMLElement(tCell);
			// "Go up to Parent Community"
			String toolTip = m_asOwner.GetString(644, ResourceConstants.PORTALCOMMONMSGS);
			// Get the Up arrrow image
			HTMLImg parent = (HTMLImg) UIConstructFactory.GetConstruct(PTImageType.ACTION_FOLDER_UP,
				true, this.m_asOwner).GetHTMLElement();
			parent.SetImgBaseUrl(ConfigHelper.GetImageServerBaseURL(m_asOwner));
			parent.SetBorder(CommonHTMLStrings.ZERO);
			parent.SetAlign(CommonHTMLStrings.MIDDLE);
			parent.SetHeight("20");
			parent.SetAlt(toolTip);
			// Get the Community image
			HTMLImg comm = (HTMLImg) UIConstructFactory.GetConstruct(PTImageType.ICON_COMMUNITY,
				true, this.m_asOwner).GetHTMLElement();
			comm.SetImgBaseUrl(ConfigHelper.GetImageServerBaseURL(m_asOwner));
			comm.SetBorder(CommonHTMLStrings.ZERO);
			comm.SetAlign(CommonHTMLStrings.ABSMIDDLE);
			comm.SetAlt(toolTip);
			String[] strings = (String[]) mediator.GetEntry();
			// Will be used as a javascript string with ' (single quote) as string delimiter so need to use " (double
			// quotes as string delimeter in the link, (clisturltemplatelinkmediator creates jscript with ')
			HTMLAnchor anchor = new HTMLAnchor("#");
			anchor.SetOnClick(NavigationCommonHelpers.URLTEMPLATE_REDIRECT_JSFUNCNAME + "(\\\'" + strings[CListURLTemplateMediator.TEMPLATEARR_INDEX_URL] + "\\\'); return false;");
			anchor.SetTitle(toolTip);
			HTMLSpan span = new HTMLSpan();
			span.SetStyleClass(PTStyleClass.NAV_TAB_TEXT);
			tCell.AddInnerHTMLElement(span);
			tCell.AddInnerHTMLString(CommonHTMLStrings.SPACE);
			span.AddInnerHTMLElement(anchor);
			// Add both images to the anchor
			anchor.AddInnerHTMLElement(parent);
			anchor.AddInnerHTMLElement(comm);
		}
    
		/// <summary>
		/// This function generates a clickable tab used to display a horizontal menu with links.
		/// </summary>
		/// <param name="tRow">The HTMLTableRow where the generated Tab is added to</param>
		/// <param name="strName">Tab display name</param>
		/// <param name="toolTip">Tooltip for the tab</param>
		/// <param name="strDivID">
		/// HTML ID for the generated Div element with the html of the links
		///  									to display when this tab is actived.
		/// </param>
		/// <throws>Exception</throws>
		protected virtual void AddGroupsTab(HTMLTableRow tRow, String strName,
			String toolTip, String strDivID)
		{
			// Tab cell
			HTMLTableCell tCell = new HTMLTableCell();
			tRow.AddInnerHTMLElement(tCell);
			tCell.SetNoWrap(true);
			tCell.SetHeight("20");
			tCell.SetID("cell" + strDivID);
			// Extra quotes and double quotes to solve javascript string issue
			// Call the javascript function that will display the links when this tab is activated.
			tCell.SetOnClick("showGroupsTabRow(\'+\"\'" + strDivID + "\'\"+\', this); return false;");
			HTMLSpan span = new HTMLSpan();
			span.AddInnerHTMLString(CommonHTMLStrings.SPACE + CommonHTMLStrings.SPACE);
			tCell.AddInnerHTMLElement(span);
			span.SetStyleClass(PTStyleClass.NAV_TAB_TEXT);
			// Community icon
			HTMLImg editCom = (HTMLImg) UIConstructFactory.GetConstruct(PTImageType.ICON_COMMUNITY,
				true, this.m_asOwner).GetHTMLElement();
			editCom.SetImgBaseUrl(ConfigHelper.GetImageServerBaseURL(m_asOwner));
			editCom.SetBorder(CommonHTMLStrings.ZERO);
			editCom.SetAlign(CommonHTMLStrings.ABSMIDDLE);
			editCom.SetAlt(toolTip);
			// Menu Arrow icon 		
			HTMLImg arrow = (HTMLImg) UIConstructFactory.GetConstruct(PTImageType.ICON_ARROW_MENU,
				true, this.m_asOwner).GetHTMLElement();
			arrow.SetImgBaseUrl(ConfigHelper.GetPortalImageServerBaseURL(m_asOwner));
			arrow.SetBorder(CommonHTMLStrings.ZERO);
			arrow.SetAlign(CommonHTMLStrings.ABSMIDDLE);
			arrow.SetAlt(toolTip);
			// Don't change this anchor without making corresponding changes in navtabsection.js on
			// the imageserver
			BrowserType browser = (BrowserType) m_asOwner.GetSubSession().GetAttribute(Interpreter.BROWSERTYPE);
			if (browser.IsNetscape4())
			{
				// Have to add the onclick handler on an anchor in Netscape 4 since it doesn't support
				// eventhandler on cells.
				HTMLAnchor anchor = new HTMLAnchor(ConstructStaticHelpers.BLANK_URL);
				anchor.SetOnClick("showGroupsTabRow(\'+\"\'" + strDivID + "\'\"+\', this); return false;");
				anchor.AddInnerHTMLElement(editCom);
				anchor.AddInnerHTMLString(strName);
        anchor.AddInnerHTMLElement(arrow);
        anchor.SetTitle(toolTip);
        span.AddInnerHTMLElement(anchor);
      } else
      {
        span.AddInnerHTMLElement(editCom);
				span.AddInnerHTMLString(strName);
				span.AddInnerHTMLElement(arrow);
			}
			// AddingSpacing between tabs
			NavigationCommonHelpers.CreateHorizontalSpacerCell(tRow);
			// Adding two cells, the tab cell and a spacer cell.
			m_nNumberCols+=2;
		}

		/// <summary>
		/// Helper function that generates HTMLAnchors from the list of provided links
		///  and adds them to the specified HTMLElement.
		/// </summary>
		/// <param name="cpList1">List of links to generate the HTMLAnchors from</param>
		/// <param name="elt">HTMLElement to add the HTMLAnchors to</param>
		/// <throws>HTMLException</throws>
		protected virtual void GenerateLinksList(ICPListEntryIterator cpList1,
			HTMLElement elt)
		{
			int i = 0;
			ICPListIterator mediator = new CListURLTemplateMediator(m_asOwner, cpList1);
			mediator.SetLabelMaxLength(50);
			i = 0;
			HTMLAnchor myAnchor;
			while (mediator.Next())
			{
				if (i++ != 0)
				{
					// Spacing between links
					elt.AddInnerHTMLString(CommonHTMLStrings.SPACE + " |" + CommonHTMLStrings.SPACE);
				}
				String[] arURLTempl = (String[]) mediator.GetEntry();
				// String labels only have one element, the label (duh)
				if (1 == arURLTempl.Length)
				{
          String label = arURLTempl[CListURLTemplateMediator.TEMPLATEARR_INDEX_LABEL];
          elt.AddInnerHTMLString(NavigationCommonHelpers.EscapeSingleQuotes(label));
          } else
        {
          String label = arURLTempl[CListURLTemplateMediator.TEMPLATEARR_INDEX_LABEL];
					// Need to escape any eventual single quotes in the name since the generated html
					// will be put into a javascript variable 
					label = GeneralHelpers.Replace(label, "\'", "\\\'");
					String urlTempl = arURLTempl[CListURLTemplateMediator.TEMPLATEARR_INDEX_URL];
					myAnchor = new HTMLAnchor("#");
					myAnchor.SetOnClick(NavigationCommonHelpers.URLTEMPLATE_REDIRECT_JSFUNCNAME + "(\\\'" + urlTempl + "\\\'); return false;");
					myAnchor.AddInnerHTMLString(label);
					elt.AddInnerHTMLElement(myAnchor);
				}
			}
		}

		/// <summary>
		/// Helper function that generates HTMLAnchors from the list of provided links
		///  and adds them to the specified HTMLElement.
		/// </summary>
		/// <param name="cpList1">List of links to generate the HTMLAnchors from</param>
		/// <param name="elt">HTMLElement to add the HTMLAnchors to</param>
		/// <throws>HTMLException</throws>
		protected virtual void GenerateAlphabetizedLinksList(ICPListEntryIterator cpList1,
			HTMLElement elt)
		{
			// this is a new method added to reverse a behavior changed between 5.x and 6.x.
			// the desired behavior of 5.x was that subcommunities and related communities
			// were given in an alphabetized list. but in 6.x these are ordered by objectid.
			// so here we basically loop through the regular iterator, jam it into a hash map
			// then alphabetize the keys, then extract values from the map based on the array
			//
			// this shouldn't be used to show the pages within a community though because
			// those pages are explicitly ordered within the community editor.
			log.Info("Inside " + GetName());
			int i = 0;
			ICPListIterator mediator = new CListURLTemplateMediator(m_asOwner, cpList1);
			mediator.SetLabelMaxLength(50);
			HTMLAnchor myAnchor;
			Hashtable hash = new Hashtable();

			while (mediator.Next())
			{
				String[] arURLTempl = (String[]) mediator.GetEntry();
				if (1 == arURLTempl.Length)
				{
					String label = arURLTempl[CListURLTemplateMediator.TEMPLATEARR_INDEX_LABEL];
					hash.Add(label,"__SKIP__URL__PARMS__");
				} 
				else
				{
					String label = arURLTempl[CListURLTemplateMediator.TEMPLATEARR_INDEX_LABEL];
					String urlTempl = arURLTempl[CListURLTemplateMediator.TEMPLATEARR_INDEX_URL];
					hash.Add(label,urlTempl);
				}
			}
			ArrayList keys = GetKeys(hash);
			keys.Sort();
			i=0;
			foreach (string lab in keys) 
			{
				if (i++ != 0)
				{
					// Spacing between links only is required after the first one
					elt.AddInnerHTMLString(CommonHTMLStrings.SPACE + " |" + CommonHTMLStrings.SPACE);
				}
				if ("__SKIP__URL__PARMS__" == hash[lab].ToString()) 
				{ // and the current page doesn't need a link
					String label = lab;
					elt.AddInnerHTMLString(NavigationCommonHelpers.EscapeSingleQuotes(label));
				} 
				else
				{ // but all other pages get the link
					String urlTempl = hash[lab].ToString();
					String label = lab;
					// Need to escape any eventual single quotes in the name since the generated html
					// will be put into a javascript variable 
					label = GeneralHelpers.Replace(label, "\'", "\\\'");
					myAnchor = new HTMLAnchor("#");
					myAnchor.SetOnClick(NavigationCommonHelpers.URLTEMPLATE_REDIRECT_JSFUNCNAME + "(\\\'" + urlTempl + "\\\'); return false;");
					myAnchor.AddInnerHTMLString(label);
					elt.AddInnerHTMLElement(myAnchor);
				}
			}
		}

		public static ArrayList GetKeys(Hashtable table)
		{
			return (new ArrayList(table.Keys));
		}	
    
		/// <summary>
		/// Puts the rows of links in a javascript variable. Also adds a Join this Community
		///  button if the user isn't member of the current community and Edit This Community button
		///  if the user has at least Edit access to the current community.
		/// </summary>
		/// <param name="strID">Name of the javascript variable</param>
		/// <param name="cpList">List of links</param>
		/// <returns>HTMLScript				HTMLScript block with the variable definition</returns>
		/// <throws>HTMLException</throws>
		/// <throws>Exception</throws>
		protected virtual HTMLScript PopulateLinksRow(String strID, ICPListEntryIterator cpList, bool bIsAlphaSort)
		{
			if (cpList != null)
			{
				// Spacer image for padding
				HTMLImg image = null;
				image = PlumtreeHelpers.GetSpacerImage("5", "1");
				// table containing single links item
				HTMLTable tTable = new HTMLTable();
				/*
				 The HTML of the table is not displayed in a regular way.
				 We get the HTML from the table as a string and put it to a javascript
				 variable. The HTML will be written to the page dynamically with javascript.
				 Set all these settings on the table element since we get the html from the
				 table as a string
				 */
         
				tTable.SetForceLineBreaksAfterSafeElements(false);
				tTable.SetImgBaseUrl(ConfigHelper.GetImageServerBaseURL(m_asOwner));
				tTable.SetBorder(CommonHTMLStrings.ZERO);
				tTable.SetCellSpacing(CommonHTMLStrings.ZERO);
				tTable.SetCellPadding(CommonHTMLStrings.ZERO);
				tTable.SetWidth(CommonHTMLStrings.ONE_HUNDRED_PERCENT);
				HTMLTableRow tRow = new HTMLTableRow();
				tRow.SetStyleClass(PTStyleClass.NAV_TABON_BG);
				tTable.AddInnerHTMLElement(tRow);
				// image in first cell
				HTMLTableCell tCell = new HTMLTableCell();
				tCell.AddInnerHTMLElement(image);
				tRow.AddInnerHTMLElement(tCell);
				// cell spawns the width of the page
				HTMLTableCell tSectionTabCell = new HTMLTableCell();
				tSectionTabCell.SetWidth(CommonHTMLStrings.ONE_HUNDRED_PERCENT);
				tSectionTabCell.SetHeight("20");
				HTMLSpan span = new HTMLSpan();
				span.SetStyleClass(PTStyleClass.BREADCRUMB_TEXT);
				// adds links nested in one span
				if (bIsAlphaSort) 
				{
					GenerateAlphabetizedLinksList(cpList, span);
				} 	else { 
					GenerateLinksList(cpList, span); 
				}
				tSectionTabCell.AddInnerHTMLElement(span);
				tRow.AddInnerHTMLElement(tSectionTabCell);
				// Add the Edit this Community and Join this Community buttons if applicable
				// Spacer image
				HTMLImg image2 = null;
				image2 = (HTMLImg) UIConstructFactory.GetConstruct(PTImageType.SPACER,
					true, m_asOwner).GetHTMLElement();
				image2.SetImgBaseUrl(ConfigHelper.GetImageServerBaseURL(m_asOwner));
				image2.SetWidth(CommonHTMLStrings.ONE);
				image2.SetHeight(CommonHTMLStrings.ONE);
				image2.SetAlign(CommonHTMLStrings.ABSMIDDLE);
				image2.SetBorder(CommonHTMLStrings.ZERO);
				image2.SetAlt("");
				// Don't show these buttons if previewing the community
				if (NavPageType.COMMUNITYPREVIEW != m_model.GetCurNavPageType())
				{
					CommunityNavPage commP = (CommunityNavPage) m_model.GetPageSpecificMethods();
					// Button to join this community if not currently a member
					if (!commP.IsMemberInCurCommunity() && commP.CanJoinCurCommunity() && !m_model.IsGuestSession())
					{
						HTMLTableCell tDivCell = new HTMLTableCell();
						tDivCell.SetHeight(CommonHTMLStrings.ONE);
						tDivCell.SetStyleClass(PTStyleClass.ACTIONBAR_DIR_DIVIDER);
						tDivCell.AddInnerHTMLElement(image2);
						tRow.AddInnerHTMLElement(tDivCell);
						// Link to directly join this community
						ASURL url = new ASURL(m_asOwner);
						url.SetLinkCreateNewSpace(CommunityPageAS.STR_MVC_CLASS_NAME,
							m_asOwner);
						url.SetImgBaseUrl(ConfigHelper.GetImageServerBaseURL(m_asOwner));
						url.SetControl(JoinCurCommunityControl.STR_MVC_CLASS_NAME);
						url.AddControlArgument(SetCommunityControl.STR_COMMUNITY_ID, XPConvert.ToString(commP.GetCurCommunityID()));
						// subscribe image
						image = (HTMLImg) UIConstructFactory.GetConstruct(PTImageType.ACTION_SUBSCRIBE_SMALL,
							true, this.m_asOwner).GetHTMLElement();
						image.SetImgBaseUrl(ConfigHelper.GetImageServerBaseURL(m_asOwner));
						image.SetAlign(CommonHTMLStrings.ABSMIDDLE);
						image.SetBorder(CommonHTMLStrings.ZERO);
						// community image
						HTMLImg commImg = (HTMLImg) UIConstructFactory.GetConstruct(PTImageType.ICON_COMMUNITY,
							true, this.m_asOwner).GetHTMLElement();
						commImg.SetImgBaseUrl(ConfigHelper.GetImageServerBaseURL(m_asOwner));
						commImg.SetAlign(CommonHTMLStrings.ABSMIDDLE);
						commImg.SetBorder(CommonHTMLStrings.ZERO);
						// Join this community					
						String toolTip = m_asOwner.GetString(653, ResourceConstants.PORTALBROWSINGMSGS);
						image.SetAlt(toolTip);
						commImg.SetAlt(toolTip);
						url.AddInnerHTMLElement(image);
						url.AddInnerHTMLElement(commImg);
						url.SetLinkTitle(toolTip);
						url.AddInnerHTMLString(toolTip);
						HTMLTableCell tCommOwner = new HTMLTableCell();
						tCommOwner.SetStyleClass(PTStyleClass.ACTIONBAR_DIR_BTN);
						tCommOwner.SetAlign(CommonHTMLStrings.RIGHT);
						tCommOwner.SetNoWrap(true);
						HTMLSpan actionSpan = new HTMLSpan();
						actionSpan.SetStyleClass(PTStyleClass.ACTIONBAR_TEXT);
						actionSpan.AddInnerHTMLElement(url.GetURLAsHTMLElement());
						actionSpan.AddInnerHTMLString(CommonHTMLStrings.SPACE);
						tCommOwner.AddInnerHTMLElement(actionSpan);
						tRow.AddInnerHTMLElement(tCommOwner);
					}
					HTMLTableCell tDividerCell = new HTMLTableCell();
					tDividerCell.SetHeight(CommonHTMLStrings.ONE);
					tDividerCell.SetStyleClass(PTStyleClass.ACTIONBAR_DIR_DIVIDER);
					tDividerCell.AddInnerHTMLElement(image2);
					tRow.AddInnerHTMLElement(tDividerCell);
					// Edit button if community owner
					if (commP.IsCurCommOwner())
					{
						ASURL url = new ASURL(m_asOwner);
						// Link to go to the Community Editor
						url.SetLinkCreateNewSpace(BaseOpenerAS.STR_MVC_CLASS_NAME, m_asOwner);
						url.SetImgBaseUrl(ConfigHelper.GetImageServerBaseURL(m_asOwner));
						url.SetControl(BaseOpenerControl.STR_MVC_CLASS_NAME);
						url.AddControlArgument(IPTOpenerConstants.STR_QS_OPENER_MODE,
							IPTOpenerConstants.OPENER_MODE_EDIT);
						// Community Class ID	
						url.AddControlArgument("in_hi_ClassID", "512");
						url.AddControlArgument("in_hi_ObjectID", XPConvert.ToString(commP.GetCurCommunityID()));
						// Edit icon
						image = (HTMLImg) UIConstructFactory.GetConstruct(PTImageType.ICON_EDIT_MENU,
							true, this.m_asOwner).GetHTMLElement();
						image.SetImgBaseUrl(ConfigHelper.GetImageServerBaseURL(m_asOwner));
						image.SetAlign(CommonHTMLStrings.ABSMIDDLE);
						image.SetBorder(CommonHTMLStrings.ZERO);
						image.SetAlt(m_asOwner.GetString(331, ResourceConstants.PORTALCOMMONMSGS));
						url.AddInnerHTMLElement(image);
						// Edit This Community
						url.AddInnerHTMLString(m_asOwner.GetString(331, ResourceConstants.PORTALCOMMONMSGS));
						HTMLTableCell tCommOwner = new HTMLTableCell();
						tCommOwner.SetStyleClass(PTStyleClass.ACTIONBAR_DIR_BTN);
						tCommOwner.SetAlign(CommonHTMLStrings.RIGHT);
						tCommOwner.SetNoWrap(true);
						HTMLSpan actionSpan = new HTMLSpan();
						actionSpan.SetStyleClass(PTStyleClass.ACTIONBAR_TEXT);
						actionSpan.AddInnerHTMLElement(url.GetURLAsHTMLElement());
						actionSpan.AddInnerHTMLString(CommonHTMLStrings.SPACE);
						actionSpan.AddInnerHTMLString(CommonHTMLStrings.SPACE);
						tCommOwner.AddInnerHTMLElement(actionSpan);
						tRow.AddInnerHTMLElement(tCommOwner);
					}
				}
				// Put the entire HTML in a javascript variable (using SafeJSVar) and return it
				return JSHelper.AddSafeJSVariable(strID, "\'" + tTable.GetDisplayString() + "\'");
			}
			// Return empty javascript block
			return new HTMLScript(HTMLScript.TYPE_JAVASCRIPT);
		}
    
		/// <summary>
		/// Puts the rows of links in a javascript variable.
		///  Same as PopulateLinksRow, except doesn't add the
		///  Join this Community and Edit this Community buttons.
		/// </summary>
		/// <param name="strID">Name of the javascript variable</param>
		/// <param name="cpList1">List of links</param>
		/// <param name="cpList2">List of links</param>
		/// <returns>HTMLScript				HTMLScript block with the variable definition</returns>
		/// <throws>HTMLException</throws>
		/// <throws>Exception</throws>
		protected virtual HTMLScript PopulateRelatedCommsRow(String strID, ICPListEntryIterator cpList)
		{
			HTMLImg image = null;
			image = PlumtreeHelpers.GetSpacerImage("5", "1");
			// table containing single links item
			HTMLTable tTable = new HTMLTable();
			tTable.SetForceLineBreaksAfterSafeElements(false);
			tTable.SetBorder(CommonHTMLStrings.ZERO);
			tTable.SetCellSpacing(CommonHTMLStrings.ZERO);
			tTable.SetCellPadding(CommonHTMLStrings.ZERO);
			tTable.SetWidth(CommonHTMLStrings.ONE_HUNDRED_PERCENT);
			tTable.SetImgBaseUrl(ConfigHelper.GetImageServerBaseURL(m_asOwner));
			HTMLTableRow tRow = new HTMLTableRow();
			tRow.SetStyleClass(PTStyleClass.NAV_TABON_BG);
			tTable.AddInnerHTMLElement(tRow);
			// image in first cell
			HTMLTableCell tCell = new HTMLTableCell();
			tCell.AddInnerHTMLElement(image);
			tRow.AddInnerHTMLElement(tCell);
			HTMLTableCell tSectionTabCell = new HTMLTableCell();
			tSectionTabCell.SetWidth(CommonHTMLStrings.ONE_HUNDRED_PERCENT);
			tSectionTabCell.SetHeight("25");
			HTMLSpan span = new HTMLSpan();
			span.SetStyleClass(PTStyleClass.BREADCRUMB_TEXT);
			tSectionTabCell.AddInnerHTMLElement(span);
			if (cpList != null)
			{
				HTMLSpan innerSpan = new HTMLSpan();
				innerSpan.SetStyleClass(PTStyleClass.BREADCRUMB_TEXT);
				if (0 == cpList.GetTotalCount())
				{
					// No related Communities
					innerSpan.AddInnerHTMLString(m_asOwner.GetString(330, ResourceConstants.PORTALCOMMONMSGS));
					innerSpan.AddInnerHTMLString(CommonHTMLStrings.SPACE);
        } else
				{
					// adds links nested in span
					GenerateAlphabetizedLinksList(cpList, innerSpan);
				}
				tSectionTabCell.AddInnerHTMLElement(innerSpan);
			}
			tRow.AddInnerHTMLElement(tSectionTabCell);
			// Put the entire HTML in a javascript variable (using SafeJSVar) and return it
			return JSHelper.AddSafeJSVariable(strID, "\'" + tTable.GetDisplayString() + "\'");
		}
	}
}