using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Plumtree.Remote.Portlet;
using Plumtree.Remote.PRC;
using Plumtree.Remote.PRC.Search;


namespace api_check
{
	/// <summary>
	/// Summary description for WebForm1.
	/// </summary>
	public class WebForm1 : System.Web.UI.Page
	{
		private void Page_Load(object sender, System.EventArgs e)
		{
			IPortletContext edk = null;
			IPortletRequest req = null;
			IPortletResponse resp = null;
			IRemoteSession remoteSession = null;
			String sAPIurl = "";
			String sLoginToken = "";
			String sAPIversion = "";

			try
			{
				edk = PortletContextFactory.CreatePortletContext(Request,Response);
				req = edk.GetRequest();
				resp = edk.GetResponse();
				sAPIurl = req.GetRemoteAPIEndpoint().ToString();
				sLoginToken = req.GetLoginToken().ToString();
				Response.Write("<p><b>Login Token:</b><br>" + sLoginToken);
				Response.Write("<p><b>API Endpoint:</b><br>" + sAPIurl);
				
			}
			catch (NotGatewayedException) 
			{
				Response.Write("Sorry! This page is designed only to run within a portal's gateway space.");
				Response.End();
			}
			catch(Exception ex)
			{
				Response.Write("<p><b>Exception:</b><br>" + ex.Message + "<br>" + ex.StackTrace);
			}		
			try 
			{
				remoteSession = edk.GetRemotePortalSession();
				sAPIversion = remoteSession.GetAPIVersion().ToString();
				Response.Write("<p><b>API Version:</b><br>" + sAPIversion);

			} 
			catch(Exception ex)
			{
				Response.Write("<p><b>Exception:</b><br>" + ex.Message + "<br>" + ex.StackTrace);
			}		
			try {
			ISearchFactory searchFactory = remoteSession.GetSearchFactory();
			IPortalSearchRequest searchRequest = searchFactory.CreatePortalSearchRequest();


				int folderId = -1;

				//search for the given folder name
				searchRequest.SetQuery("*");

				// only search for folders
				ObjectClass[] objectTypes = {ObjectClass.DocumentFolder};
				searchRequest.SetObjectTypesToSearch(objectTypes);

				ISearchResponse searchResponse = searchRequest.Execute();
				ISearchResultSet resultSet = searchResponse.GetResultSet();
				int numResults = searchResponse.GetReturnedCount();
			
				Response.Write("<p><b>Objects Found in Search:</b><br>" + numResults.ToString());


			}
			catch(Exception ex)
			{
				Response.Write("<p><b>Exception:</b><br>" + ex.Message + "<br>" + ex.StackTrace);
			}		

		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
